<?php
   // Start the session
    session_cache_limiter('nocache'); //spune la browser sa nu faca cache; se folosete inainte de session_start();
    session_start();

    // Check to see if actually logged in. If not, redirect to login page
    if (!isset($_SESSION['loggedIn']) || $_SESSION['loggedIn'] == false) {
        header("Location: setup/auth2.php");
    }

/*
-----------------------------------------------------------------------------------------------------------------
START OF DEMO SCRIPT CODE. THIS CODE IS ONLY USED BY DEMO SCRIPT. YOU DO NOT NEED TO ADD THIS CODE TO YOUR SCRIPT.
-----------------------------------------------------------------------------------------------------------------
*/

//Load configuration and settings files that are responsible for including files required by Auto PHP Licenser
require_once("settings.php");
require_once("setup/setup-settings.php");

//Set basic variables such as page title, default message, etc.
$demo_page_title="Uninstall License";
$demo_page_message="Your license allow only one installation of your script. Uninstalling the license, allow you to re-install this script on different domain or server.";
$demo_page_class="alert alert-primary";

//Get all variables submitted by user
if (!empty($_POST) && is_array($_POST))
    {
    extract(array_map("trim", $_POST), EXTR_SKIP); //automatically make a variable from each argument submitted by user (don't overwrite existing variables)
    }

/*
-----------------------------------------------------------------------------------------------------------------
END OF DEMO SCRIPT CODE. THIS CODE IS ONLY USED BY DEMO SCRIPT. YOU DO NOT NEED TO ADD THIS CODE TO YOUR SCRIPT.
-----------------------------------------------------------------------------------------------------------------
*/

/*
-----------------------------------------------------------------------------------------------------------------
START OF AUTO PHP LICENSER CODE REQUIRED TO UNINSTALL LICENSE. YOU SHOULD ADD THIS CODE TO YOUR SCRIPT.
-----------------------------------------------------------------------------------------------------------------
*/

if (isset($submit_ok))
    {
    //Function should be provided with MySQLi link (only when database is used).
    //Function will return array with 'notification_case' and 'notification_text' keys, where 'notification_case' contains action status and 'notification_text' contains action summary.
    $license_notifications_array=aplUninstallLicense(null);

    if ($license_notifications_array['notification_case']=="notification_license_ok") //'notification_license_ok' case returned - operation succeeded
        {
        $demo_page_message="Your $DEMO_PRODUCT_NAME license was uninstalled! $DEMO_PRODUCT_NAME will now stop working!";
        $demo_page_class="alert alert-success";
        }
    else //Other case returned - operation failed
        {
        $demo_page_message="Your $DEMO_PRODUCT_NAME license uninstallation failed because of this reason: ".$license_notifications_array['notification_text'];
        $demo_page_class="alert alert-danger";
        }
    }

/*
-----------------------------------------------------------------------------------------------------------------
END OF AUTO PHP LICENSER CODE REQUIRED TO UNINSTALL LICENSE. YOU SHOULD ADD THIS CODE TO YOUR SCRIPT.
-----------------------------------------------------------------------------------------------------------------
*/
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <title><?php echo "$demo_page_title - $DEMO_PRODUCT_NAME - Protected by $ORIGINAL_PRODUCT_NAME"; ?></title>
	
<link rel="apple-touch-icon" sizes="57x57" href="<?php echo $linkhttps . $linkdomain ;?>images/apple-icon-57x57.png" />
<link rel="apple-touch-icon" sizes="60x60" href="images/apple-icon-60x60.png" />
<link rel="apple-touch-icon" sizes="72x72" href="images/apple-icon-72x72.png" />
<link rel="apple-touch-icon" sizes="76x76" href="images/apple-icon-76x76.png" />
<link rel="apple-touch-icon" sizes="114x114" href="images/apple-icon-114x114.png" />
<link rel="apple-touch-icon" sizes="120x120" href="images/apple-icon-120x120.png" />
<link rel="apple-touch-icon" sizes="144x144" href="images/apple-icon-144x144.png" />
<link rel="apple-touch-icon" sizes="152x152" href="images/apple-icon-152x152.png" />
<link rel="apple-touch-icon" sizes="180x180" href="images/apple-icon-180x180.png" />
<link rel="icon" type="image/png" sizes="192x192"  href="images/android-icon-192x192.png" />
<link rel="icon" type="image/png" sizes="32x32" href="images/favicon-32x32.png" />
<link rel="icon" type="image/png" sizes="96x96" href="images/favicon-96x96.png" />
<link rel="icon" type="image/png" sizes="16x16" href="images/favicon-16x16.png" />
<link rel="manifest" href="<?php echo $linkhttps . $linkdomain ;?>images/manifest.json" />	
	
    <link rel="stylesheet" href="css/fontawesome/css/all.min.css">
    <link href="css/style.min.css" rel="stylesheet">
  </head>
  <body class="app header-fixed sidebar-fixed aside-menu-fixed sidebar-lg-show">
    <header class="app-header navbar">
      <button class="navbar-toggler sidebar-toggler d-lg-none mr-auto" type="button" data-toggle="sidebar-show">
        <span class="navbar-toggler-icon"></span>
      </button>
       <a class="navbar-brand" href="https://www.webradio-hosting.com" title="webradio hosting" target="_blank"><strong>&nbsp; Webradio Hosting</strong></a>
    </header>
    <div class="app-body">
      <div class="sidebar">
        <nav class="sidebar-nav">
          <ul class="nav">
            <li class="nav-title"><?php echo $DEMO_PRODUCT_NAME; ?></li>
            <li class="nav-item"><a class="nav-link" href="script-install.php"><i class="fas fa-home"></i> &nbsp; Start Page</a></li>
            <li class="divider"></li>			
            <li class="nav-title">LICENSE</li>	
            <li class="divider"></li>			
            <li class="nav-item"><a class="nav-link" href="install.php"><i class="fas fa-key"></i> &nbsp; Install License</a></li>
            <li class="nav-item"><a class="nav-link" href="license.php"><i class="fas fa-user-lock"></i> &nbsp; Verify License</a></li>
            <li class="nav-item"><a class="nav-link" href="updates.php"><i class="far fa-clock"></i> &nbsp; Verify Updates</a></li>
            <li class="nav-item"><a class="nav-link" href="support.php"><i class="far fa-life-ring"></i> &nbsp; Verify Support</a></li>
            <li class="nav-item"><a class="nav-link" href="uninstall.php"><i class="fas fa-lock-open"></i> &nbsp; Uninstall License</a></li>
            <li class="divider"></li>
			
            <li class="nav-title">Script Setup</li>	
            <li class="nav-item"><a class="nav-link" href="setup.php"><i class="fas fa-cogs"></i> &nbsp; Script Settings</a></li>
            <li class="nav-item"><a class="nav-link" href="setup/logout2.php"><i class="fas fa-sign-out-alt"></i> &nbsp; Log out</a></li>			
            <li class="divider"></li>			
						

            <li class="nav-title">Other Scripts</li>
            <li class="divider"></li>
            <li class="nav-item"><a class="nav-link" href="https://www.webradio-hosting.com/liverequest.php" target="_blank"><i class="fas fa-address-card"></i> &nbsp; Live Request - Deejay Utility</a></li>
          </ul>
        </nav>
      </div>
      <main class="main">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="<?php echo $ORIGINAL_PRODUCT_URL; ?>"><?php echo $ORIGINAL_PRODUCT_NAME; ?></a></li>
          <li class="breadcrumb-item active"><?php echo $demo_page_title; ?></li>
        </ol>
        <div class="container-fluid">
          <div class="animated fadeIn">
            <div class="card">
              <div class="card-header"><i class="fas fa-code"></i><?php echo $DEMO_PRODUCT_NAME; ?></div>
              <div class="card-body">
                <div class="<?php echo $demo_page_class; ?>" role="alert"><strong><?php echo $demo_page_message; ?></strong></div>
                <?php if (!isset($submit_ok)) { ?>
                
                <?php } ?>
              </div>
            </div>
            <div class="card">
              <form action="<?php echo basename(__FILE__); ?>" method="post">
              <div class="card-header"><i class="fas fa-lock-open"></i><?php echo $demo_page_title; ?></div>
              <?php if ($demo_page_class!="alert alert-success") { ?>
              <div class="card-footer">
                <button class="btn btn-sm btn-primary" name="submit_ok"><i class="fas fa-check"></i> Submit</button>
              </div>
              <?php } ?>
              <?php if ($demo_page_class=="alert alert-success") { ?>
              <div class="card-body">
                <p class="h4">Uninstalling License... Completed!</p>
                <div class="progress">
                  <div class="progress-bar progress-bar-striped bg-success" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width:100%"></div>
                </div>
                <?php if ($_SERVER['HTTP_HOST']=="www.demo.phpmillion.com") { ?>
                <br><br>
                <div class="jumbotron">
                  <p class="lead">Protect PHP code right away!</p>
                  <p class="lead"><a class="btn btn-primary btn-lg" href="<?php echo $ORIGINAL_PRODUCT_URL; ?>" target="_blank" role="button">Buy <?php echo $ORIGINAL_PRODUCT_NAME; ?> Now</a></p>
                </div>
                <?php } ?>
              </div>
              <?php } ?>
              </form>
            </div>
          </div>
        </div>
      </main>
    </div>
     <footer class="app-footer">
      <div>
        <a href="https://www.webradio-hosting.com">Webradio Hosting</a> <span>&copy; <?php echo date("Y"); ?></span>
      </div>
      <div class="ml-auto">
        <span>Protected by</span> <a href="<?php echo $ORIGINAL_PRODUCT_URL; ?>"><?php echo $ORIGINAL_PRODUCT_NAME; ?></a>
      </div>
    </footer>
    <script src="js/jquery/jquery.min.js"></script>
    <script src="js/bootstrap/bootstrap.min.js"></script>
    <script src="js/coreui/coreui.min.js"></script>
  </body>
</html>
